
Type TSpringRectangleRope

	Field _rectTexture:TImage
	Field _rectBody:TBody[]
	Field _rectGeom:TGeom[]
	Field _linearSpring:TLinearSpring[]
	
	Field _rectangleWidth:Int = 20
	Field _rectangleHeight:Int = 20
	Field _rectangleMass:Float = 1
	Field _position:Vector2 = Vector2.Zero()
	Field _rectangleCount:Int = 20
	
	Field _springLength:Float = 25
	Field _springConstant:Float = 1
	Field _dampningConstant:Float = 1
	
	Field _collisionGroup:Int = 0
	
	Method GetFirstBody:TBody()
		Return _rectBody[0]
	End Method
	
	Method SetFirstBody(value:TBody)
		_rectBody[0] = value
	End Method
	
	Method GetPosition:Vector2()
		Return _position.Copy()
	End Method
	
	Method SetPosition(value:Vector2)
		_position.X = value.X
		_position.Y = value.Y
	End Method
	
	Method GetRectangleCount:Int()
		Return _rectangleCount
	End Method
	
	Method SetRectangleCount(value:Int)
		_rectangleCount = value
	End Method
	
	Method GetRectangleWidth:Int()
		Return _rectangleWidth
	End Method
	
	Method SetRectangleWidth(value:Int)
		_rectangleWidth = value
	End Method
	
	Method SetRectangleHeight(value:Int)
		_rectangleHeight = value
	End Method
	
	Method GetRectangleHeight:Int()
		Return _rectangleHeight
	End Method
	
	Method GetRectangleMass:Float()
		Return _rectangleMass
	End Method
	
	Method SetRectangleMass(value:Float)
		_rectangleMass = value
	End Method
	
	Method SetSpringLength(value:Float)
		_springLength = value
	End Method
	
	Method GetSpringLength:Float()
		Return _springLength
	End Method
	
	Method GetSpringConstant:Float()
		Return _springConstant
	End Method
	
	Method SetSpringConstant(value:Float)
		_springConstant = value
	End Method
	
	Method GetDampningConstant:Float()
		Return _dampningConstant
	End Method
	
	Method SetDampningConstant(value:Float)
		_dampningConstant = value
	End Method
	
	Method GetCollisionGroup:Int()
		Return _collisionGroup
	End Method
	
	Method SetCollisionGroup(value:Int)
		_collisionGroup = value
	End Method
	
	
	Method Draw()
		For Local i:Int = 0 To _rectGeom.Length - 1
			SetOrigin(_rectGeom[i].GetPosition().X, _rectGeom[i].GetPosition().Y)
			SetRotation(MathHelper.ToDegrees(_rectGeom[i].GetRotation()))
			DrawImage(_rectTexture, 0, 0)
		Next
		SetOrigin(0, 0)
		SetRotation(0)
	End Method
	
	Method Load(physics:TPhysicsSimulator)
		_rectTexture = TDrawingHelper.CreateRectangleTexture(_rectangleWidth, _rectangleHeight, TColor.White, TColor.Black)
		MidHandleImage(_rectTexture)
		
		_linearSpring = New TLinearSpring[_rectangleCount - 1]
		_rectBody = New TBody[_rectangleCount]
		_rectBody[0] = TBodyFactory.CreateRectangleBody(physics, _rectangleWidth, _rectangleHeight, _rectangleMass)
		_rectBody[0].SetPosition(_position)
		
		For Local i:Int = 1 To _rectBody.Length - 1
			_rectBody[i] = TBodyFactory.CloneBody(physics, _rectBody[0])
			_rectBody[i].SetPosition(Vector2.AddVectors(_rectBody[i - 1].GetPosition(), Vector2.Create(0, _springLength)))
		Next
		
		_rectGeom = New TGeom[_rectangleCount]
		_rectGeom[0] = TGeomFactory.CreateRectangleGeom(physics, _rectBody[0], _rectangleWidth, _rectangleHeight)
		_rectGeom[0].SetCollisionGroup(_collisionGroup)
		For Local j:Int = 1 To _rectGeom.Length - 1
			_rectGeom[j] = TGeomFactory.CloneGeom(physics, _rectBody[j], _rectGeom[0])
		Next
		
		For Local k:Int = 0 To _linearSpring.Length - 1
			_linearSpring[k] = TControllerFactory.CreateLinearSpring(physics, _rectBody[k], Vector2.Zero(), _rectBody[k + 1], Vector2.Zero(), _springConstant, _dampningConstant)
		Next
	End Method
End Type
